*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file updated for Nids Wave 4

* THIS IS 3rd WEALTH DO FILE - PREPARING VARIABLES FOR IMPUTATION: 3 OF 6
* THIS DO FILE PREPARES THE RELEVANT WEALTH VARIABLES FOR IMPUTATION

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master wealth do file (1 of 6)"

version 13.0

*=====================================================================================================================================
*USING THE ADULT AND INDDERIVED FILES TO CREATE A BIOCHILDREN VARIABLE
* Counting the number of biological children 18 or younger still living in this household


*Reshaping the adult questionnaire into long format (birth history variables)

use "$DataIN\Adult_$VersionIN.dta", clear

rename w4_a_* *

keep pid w4_hhid bhres* bhchild_id*
reshape long bhchild_id bhres, i(pid) j(child)

gen issue=1 if bhres==1 & bhchild_id==.
gen issue_d=issue!=.
label variable issue_d "resisdent children with no id"
rename pid m_pid
rename bhchild_id pid

*Merging with individual derived file
drop if pid == .
duplicates drop pid, force   //TEMP FIX. MICHELLE TO DROP ONCE BH SECTION IS FIXED

merge 1:1 pid using "$DataIN\indderived_$VersionIN.dta"
drop if _m == 2
drop _merge

rename w4_* *
rename hhid w4_hhid
gen hhchild=0
replace hhchild = 1 if best_age_yrs<=18 & best_age_yrs>=0

gen biochild=0
replace biochild=1 if m_pid!=. & hhchild==1
egen biochildren = sum(biochild), by(m_pid)

keep pid m_pid w4_hhid biochildren issue_d
drop pid
rename m_pid pid
keep pid w4_hhid biochildren issue_d

duplicates drop pid, force

*------------------------------------------------------------------------------------------------------------------------------------

* MERGING WITH THE DATASET CREATED IN THE DO FILE "Income - Merging datasets to create income variables (2 of 7)"
merge 1:1 pid  using "$DataOUT\data.dta"
drop _merge

set more off
*-------------------------------------------------------------------------------------------------------------------------------------

* RESPONSE STATUS

* Variable that indicates whether the individual has a response at all (including proxies)
gen response=w4_ind_outcome==1
label variable response "Did individual respond or not (incl. proxies)"
label values response dummy

* Variable that indicates the outcome of attempted sampling of this unit
gen responseoutcome=response
replace responseoutcome=2 if proxy==1
label define responseoutcome 0 "Non-response" 1 "Adult" 2 "Proxy"
label values responseoutcome responseoutcome 

* Month of interview
gen temp=.
replace temp=intrv_m if intrv_y==2014
replace temp=intrv_m+12 if intrv_y==2015
replace temp=25 if temp==.
rename temp intmonth

* Year of interview
gen int2014=intrv_y==2014
gen int2015=intrv_y==2015
*replace int2010=1 if intrv_y==2008
*replace int2011=1 if intrv_y==-3

*-------------------------------------------------------------------------------------------------------------------------------------

* DEMOGRAPHICS

* Gender
********
recode best_gen (1=1 "Male") (2=0 "Female"), gen(male)
replace male=roster_male if male==.
label variable male "Male dummy"
gen male_d=male!=.

* Race
******

rename best_race race
recode race (min/0=.)
gen race_d=race!=.
replace race=1 if race==. 
*Set race to African for all non-responders, but we control for this with a dummy.
recode race (1=1 "African") (2/5=0 "Non-African"), gen(african)
recode race (2=1 "Coloured") (3/5=0 "Non-Coloured") (1=0 "Non-Coloured") , gen(coloured)
recode race (3=1 "Asian_Indian") (1/2=0 "Non-asian_indian") (4/5=0 "Non-asian_indian"), gen(asian_indian)
recode race (4=1 "White") (1/3=0 "Non-White") (5=0 "Non-White"), gen(white)
recode race (5=1 "Other") (1/4=0 "Non-Other"), gen(other)


* Age
******

recode best_age_yrs (min/-1=.)
replace best_age_yrs=0 if best_age_yrs==.
gen age_d=best_age_yrs==0
gen agesq=best_age_yrs^2
label variable agesq "Age squared at interview"
gen agecu=best_age_yrs^3
label variable agecu "Age cubed at interview"

* Schooling
************

recode best_edu (-9/0=0) (1=1 "Grade 1") (2=2 "Grade 2") (3=3 "Grade 3") (4=4 "Grade 4") (5=5 "Grade 5") ///
(6=6 "Grade 6") (7=7 "Grade 7") (8=8 "Grade 8") (9=9 "Grade 9") (10=10 "Grade 10") (11=11 "Grade 11") ///
(12=12 "Grade 12") (13=10) (14=11) (15=12) (25=0 "No schooling") (16/24=12) (26/max=.), gen(schooling)
gen schooling_d=schooling!=.
gen schoolingsq=schooling^2
label variable schooling "Schooling"

* Education dummies
recode best_edu (-9/0=0) (0/12=0) (12/15=0) (25=0), gen(postschool)
replace postschool=0 if best_edu<0 & best_edu>=-9 & schooling<12
gen postschool_d=postschool!=.
tab postschool, gen(best_edu)
rename best_edu2 cert_nomat
rename best_edu3 dip_nomat
rename best_edu4 cert_mat
rename best_edu5 dip_mat
rename best_edu6 bachelors
rename best_edu7 bach_dip
rename best_edu8 honours
rename best_edu9 postgrad
rename best_edu10 othered

* Number of post-school years
recode postschool (16/17=1) (18/19=1) (20=3) (21=4) (22=4) (23=6) (24=0), gen(postschoolyears)

* Proxy for work experience
gen experience=best_age_yrs-6-schooling-postschoolyears

* Trade union membership
gen tradeunion=em1tru==1
label variable tradeunion "Trade union membership"

*------------------------------------------------------------------------------------------------------------------------------------

* HOUSEHOLD VARIABLES FOR HOUSEHOLD LEVEL WAGE IMPUTATIONS

* Household mode race
egen hhrace=mode(race), by(w4_hhid) minmode
egen hhracetemp=mode(race), by(w4_hhid) maxmode
replace hhrace=hhracetemp if hhrace==.
drop hhracetemp
gen hhrace_d=hhrace!=.
replace hhrace=0 if hhrace==.

* Maximum household education
egen hhedu=max(schooling), by(w4_hhid)
egen hhpostedu=max(postschool), by(w4_hhid)
recode hhpostedu (16/17=12) (18/19=13) (20/21=15) (22=16) (23=17) (24=.)
replace hhedu=hhpostedu if hhpostedu!=0 & hhpostedu!=.
replace hhedu=0 if hhedu==. & response==1
gen hhedusq=hhedu^2

* Median household age
egen hhage=median(best_age_yrs) if best_age_yrs>=0 & best_age_yrs<110, by(w4_hhid)
sort w4_hhid hhage
replace hhage=0 if hhage==.
egen max_age = max(hhage), by(w4_hhid)
replace hhage=max_age if hhage==0 &  max_age!=0 & max_age!=.
drop max_age

gen hhage_d=hhage!=.
replace hhage=0 if hhage==.

* Dummy variable for a trade union member present in household
egen hhtu=max(tradeunion), by(w4_hhid)

* Dummy for household receiving grant income
gen spen_rec=1 if incgovpen==1
replace spen_rec=0 if spen_rec!=1 & response==1 
gen dis_rec=1 if incdis==1
replace dis_rec=0 if dis_rec!=1 & response==1 
gen chld_rec=1 if incchld==1
replace chld_rec=0 if chld_rec!=1 & response==1 
gen fost_rec=1 if incfos==1
replace fost_rec=0 if fost_rec!=1 & response==1 
gen care_rec=1 if inccare==1
replace care_rec=0 if care_rec!=1 & response==1 

gen hhgrant=0
replace hhgrant=1 if spen_rec==1 | dis_rec==1 | chld_rec==1 | fost_rec==1 | care_rec==1
egen temp=sum(hhgrant), by(w4_hhid)
gen temp2=temp>0 & temp!=.
replace hhgrant=temp2
drop temp*

* Dummy for there being any children in the household
gen hhchld_d=hhchildren>0 & hhchildren!=.

*-----------------------------------------------------------------------------------------------------------------------------------

* CLEANING THE ASSET VARIABLES

* Value of first property
gen houseval_rec=ownhome==1
gen houseval=propvalue

* Value of other properties
gen otherhouseval_rec=ownotherhome==1
gen otherhouseval=otherpropvalue

*-----------------------------------------------------------------------------------------------------------------------------------

* CLEANING THE DEBT VARIABLES

* Debt on first property
gen housedebt_rec=(ownhome==1 & ownfullypaid!=1)
gen housedebt=bondowing

* Debt on other propeties
gen otherhousedebt_rec=(ownotherhome==1 & ownotherfullypaid!=1)
gen otherhousedebt=otherbondowing

* Livestock Assets
gen cattle_rec=aglscat==1
recode aglscatsel (min/0=.), gen(cattle)

gen sheep_rec=aglsshp==1
recode aglsshpsel (min/0=.), gen(sheep)

gen goats_rec=aglsgt==1
recode aglsgtsel (min/0=.), gen(goats)

gen pigs_rec=aglspig==1
recode aglspigsel (min/0=.), gen(pigs)

gen horses_rec=aglshrs==1
recode aglshrssel (min/0=.), gen(horses)

gen donkeys_rec=aglsdnk==1
recode aglsdnksel (min/0=.), gen(donkeys)

gen chickens_rec=aglschc==1
recode aglschcsel (min/0=.), gen(chickens)

*-----------------------------------------------------------------------------------------------------------------------------------

* INDIVIDUAL-LEVEL VARIABLES

* Business Assets

gen busass_rec=(ems==1 & emssll==1)
recode emslft (min/0=.), gen(busass)

gen temp1=.
replace temp1=2500 if emslft_brac4==3   					//<5 000
replace temp1=5000 if emslft_brac4==2  						//=5 000
replace temp1=7500 if emslft_brac4==1 & emslft_brac2==3 	//>5 000 & <10 000
replace temp1=10000 if emslft_brac2==2  					//=10 000
replace temp1=17500 if emslft_brac2==1 & emslft_brac1==3 	//>10 000 & < 25 000
replace temp1=25000 if emslft_brac1==2 						//=25 000
replace temp1=37500 if emslft_brac1==1 & emslft_brac3==3 	//>25 000 & < 50 000 
replace temp1=50000 if emslft_brac3==2 						//=50 000
replace temp1=75000 if emslft_brac3==1 & emslft_brac5==3 	//>50 000 & < 100 000 
replace temp1=100000 if emslft_brac5==2 					//=100 000
replace temp1=550000 if emslft_brac5==1 & emslft_brac6==3	//>100 000 & <1 000 000
replace temp1=1000000 if emslft_brac6==2  					//=1 000 000
replace temp1=2000000 if emslft_brac6==1 					//>1 000 000 

replace busass=temp1 if ems==1 & emssll==1 & busass==.

drop temp1

* Business Debts

gen busdeb_rec=(ems==1 & emssll==3)
recode emsdbt (min/0=.), gen(busdeb)

gen temp1=.
replace temp1=2500 if emsdbt_brac4==3   					//<5 000
replace temp1=5000 if emsdbt_brac4==2  						//=5 000
replace temp1=7500 if emsdbt_brac4==1 & emsdbt_brac2==3 	//>5 000 & <10 000
replace temp1=10000 if emsdbt_brac2==2  					//=10 000
replace temp1=17500 if emsdbt_brac2==1 & emsdbt_brac1==3 	//>10 000 & < 25 000
replace temp1=25000 if emsdbt_brac1==2 						//=25 000
replace temp1=37500 if emsdbt_brac1==1 & emsdbt_brac3==3 	//>25 000 & < 50 000 
replace temp1=50000 if emsdbt_brac3==2 						//=50 000
replace temp1=75000 if emsdbt_brac3==1 & emsdbt_brac5==3 	//>50 000 & < 100 000 
replace temp1=100000 if emsdbt_brac5==2 					//=100 000
replace temp1=550000 if emsdbt_brac5==1 & emsdbt_brac6==3	//>100 000 & <1 000 000
replace temp1=1000000 if emsdbt_brac6==2  					//=1 000 000
replace temp1=2000000 if emsdbt_brac6==1 					//>1 000 000 

replace busdeb=temp1 if ems==1 & emssll==3 & busdeb==.

drop temp1

*Home Loan/ Bond debt individual
rename dtbnd bondowing_i_rec
recode dtbnd_b (min/0=.), gen(bondowing_i)
gen temp1 = .
replace temp1 = 1/8*dtbnd_b if dtbnd_sharebrac2 == 3   							//<1/4
replace temp1 = 1/4*dtbnd_b if dtbnd_sharebrac2 == 2   							//=1/4
replace temp1 = 3/8*dtbnd_b if dtbnd_sharebrac2 == 1  & dtbnd_sharebrac1 == 3   //>1/4 & <1/2
replace temp1 = 1/2*dtbnd_b if dtbnd_sharebrac1 == 2   							//=1/2
replace temp1 = 5/8*dtbnd_b if dtbnd_sharebrac1 == 1  & dtbnd_sharebrac3 == 3   //>1/2 & < 3/4
replace temp1 = 3/4*dtbnd_b if dtbnd_sharebrac3 == 2  							//=3/4
replace temp1 = 7/8*dtbnd_b if dtbnd_sharebrac3 == 1   							//>3/4

replace bondowing_i = temp1 if bondowing_i_rec == 1 & dtbnd_joint == 2 & dtbnd_sharev < 0 & bondowing_i == . 
drop temp1

* Vehicle Assets
gen priveh_rec=ownveh==1
recode ownveh_v (min/0=.), gen(priveh)

*gen bakkie_rec=ownvehcom==1
*recode ownvehcm_v(min/0=.), gen(bakkie)

gen scooter_rec=ownmot==1
recode ownmot_v (min/0=.), gen(scooter)

* Vehicle Debts

gen vehdebt_rec=dtveh==1
recode dtveh_b (min/0=.), gen(vehdebt)

recode dtveh_sharev (min/0=.), gen(vehdebt_ind)
gen temp1 = .
replace temp1 = 1/8*dtveh_b if dtveh_sharebrac2 == 3   							//<1/4
replace temp1 = 1/4*dtveh_b if dtveh_sharebrac2 == 2   							//=1/4
replace temp1 = 3/8*dtveh_b if dtveh_sharebrac2 == 1  & dtveh_sharebrac1 == 3   //>1/4 & <1/2
replace temp1 = 1/2*dtveh_b if dtveh_sharebrac1 == 2   							//=1/2
replace temp1 = 5/8*dtveh_b if dtveh_sharebrac1 == 1  & dtveh_sharebrac3 == 3   //>1/2 & < 3/4
replace temp1 = 3/4*dtveh_b if dtveh_sharebrac3 == 2  							//=3/4
replace temp1 = 7/8*dtveh_b if dtveh_sharebrac3 == 1   							//>3/4

replace vehdebt_ind = temp1 if dtveh == 1 & dtveh_joint == 2 & dtveh_sharev<0 & vehdebt_ind == . 
drop temp1

* Financial Assets

*gen cash_rec=ascash==1
*recode ascash_v (min/0=.), gen(cash)

//Check if individuals give a negetive value in the bank balance variable. Previously all negetive values were coded to "."

	//gen bank_rec=asacc==1
	gen bank_rec = asacc==1 & (asacc_v > -10 & asacc_v !=.) 
	replace bank_rec=asacc == 0 if bank_rec == 1 & asacc_v<0 & asacc_brac1 == 3  //individuals earning less than zero under brackets
	recode asacc_v (min/-3 =.), gen(bank)

gen temp1=.

replace temp1=0 if asacc_brac1==2  							//=0
replace temp1=250 if asacc_brac1==1 & asacc_brac2==3 	 	//>0 & <500
replace temp1=500 if asacc_brac2==2  						//=500
replace temp1=2750 if asacc_brac2==1 & asacc_brac3==3 		//>500 & < 5 000
replace temp1=5000 if asacc_brac3==2 						//=5 000
replace temp1=27500 if asacc_brac3==1 & asacc_brac4==3 		//>5 000 & < 50 000 
replace temp1=50000 if asacc_brac4==2 						//=50 000
replace temp1=75000 if asacc_brac4==1 & asacc_brac5==3 		//>50 000 & < 100 000 
replace temp1=100000 if asacc_brac5==2 						//=100 000
replace temp1=200000 if asacc_brac5==1						//>100 000 

replace bank=temp1 if asacc == 1 & asacc_v <0  & bank==.
drop temp1

* Individual's possessions

recode hgsell_a (min/-3 =.), gen(posses_i)
gen temp1=.
gen posses_i_rec =1 if hgsell_a!=.

replace temp1=2500 if asacc_brac2==3  						//<5 000
replace temp1=5000 if hgsell_brac1==4==2				 	//=5000
replace temp1=7500 if hgsell_brac4==1 & hgsell_brac2==3 	//>5000 & <10000
replace temp1=10000 if hgsell_brac2==2  					//=10 000
replace temp1=17500 if hgsell_brac2==1 & hgsell_brac1==3 	//>10000 & < 25000
replace temp1=25000 if hgsell_brac1==2 						//=25 000
replace temp1=37500 if hgsell_brac1==1 & hgsell_brac3==3 	//>25000 & < 50000 
replace temp1=50000 if hgsell_brac3==2 						//=50 000
replace temp1=75000 if hgsell_brac3==1 & hgsell_brac5==3 	//>50000 & < 100000 
replace temp1=100000 if hgsell_brac5==2 					//=100 000
replace temp1=550000 if hgsell_brac5==1 & hgsell_brac6==3 	//>100000 & < 1000000 
replace temp1=1000000 if hgsell_brac6==2 					//=1 000 000
replace temp1=2000000 if hgsell_brac6==1					//>1000000 

replace posses_i=temp1 if hgsell_a <0  & posses_i==.
drop temp1

gen stocks_rec=asfin==1
recode asfin_v (min/0=.), gen(stocks)
gen temp1=.
replace temp1=250 if asfin_brac5==3   						//<500
replace temp1=500 if asfin_brac5==2  						//=500
replace temp1=2750 if asfin_brac5==1 & asfin_brac4==3 	 	//>500 & <5 000
replace temp1=5000 if asfin_brac4==2  						//=5 000
replace temp1=27500 if asfin_brac4==1 & asfin_brac1==3 		//>5 000 & < 50 000
replace temp1=50000 if asfin_brac1==2 						//=50 000
replace temp1=275000 if asfin_brac1==1 & asfin_brac2==3 	//>50 000 & < 500 000 
replace temp1=500000 if asfin_brac2==2 						//=500 000
replace temp1=750000 if asfin_brac2==1 & asfin_brac3==3 	//>500 000 & < 1 000 000 
replace temp1=1000000 if asfin_brac3==2 					//=1 000 000
replace temp1=3000000 if asfin_brac3==1 & asfin_brac6==3	//>1 000 000 & <5 000 000
replace temp1=5000000 if asfin_brac6==2  					//=5 000 000
replace temp1=10000000 if asfin_brac6==1 					//>5 000 000 

replace stocks=temp1 if asfin == 1 & asfin_v <0  & stocks==.
drop temp1

* Financial Debts
//Bank, flag????
gen bankdebt_rec=dtbnk==1
recode dtbnk_b (min/0=.), gen(bankdebt)

* Financial Debts/ Overdraft
//Bank, flag????

		gen bankoverdraft_rec = asacc==1 & asacc_v <= -10 |asacc_brac1 == 3 

		recode asacc_v (0/max = .), gen(bankoverdraft)
		replace bankoverdraft =. if bankoverdraft == -9 | bankoverdraft == -8 | bankoverdraft == -5 | bankoverdraft == -3
		
		gen temp1 = .
		replace temp1=-250 if dtacc_brac1==3					   	//<500 & > 0 overdraft
		replace temp1=-500 if dtacc_brac1==2 						//=500 overdraft
		replace temp1=-2750 if dtacc_brac2==3 & dtacc_brac1==1 		//<5 000 & > 500 overdraft
		replace temp1=-5000 if dtacc_brac2==2 						//=5 000 overdraft
		replace temp1=-27500 if dtacc_brac3==3 & dtacc_brac2==1		//<50 000 & > 5 000 overdraft
		replace temp1=-50000 if dtacc_brac3==2  					//=50 000 overdraft
		replace temp1=-75000 if dtacc_brac4==3 & dtacc_brac3==1 	//<100 000 & >50 000 overdraft
		replace temp1=-100000 if dtacc_brac4==2  					//=100 000 overdraft 
		replace temp1=-200000 if dtacc_brac4==1   					//>100 000 overdraft   //Flag check........?

		replace bankoverdraft = temp1 if asacc == 1 & asacc_v < 0  & bankoverdraft == .
		drop temp1
		replace bankoverdraft = -1* bankoverdraft

gen micro_rec=dtmic==1
recode dtmic_b (min/0=.), gen(micro)

gen masho_rec=dtmsh==1
recode dtmsh_b (min/0=.), gen(masho)

gen studentloan_rec=dtstubnk==1
recode dtstubnk_b (min/0=.), gen(studentloan)

gen otherstudentloan_rec=dtstuo==1
recode dtstuo_b (min/0=.), gen(otherstudentloan)

gen creditcard_rec=dtcre==1
recode dtcre_b (min/0=.), gen(creditcard)

gen store_rec=dtstr==1
recode dtstr_b (min/0=.), gen(store)

gen hirep_rec=dthp==1
recode dthp_b (min/0=.), gen(hirep)

gen famloan_rec=dtflloan==1
recode dtflloan_b (min/0=.), gen(famloan)

gen friendloan_rec=dtfrloan==1
recode dtfrloanbal (min/0=.), gen(friendloan)

gen emploan_rec=dtemploan==1
recode dtemploan_b (min/0=.), gen(emploan)

gen unpaidtax_rec=dtunpdtax==1
recode dtunpdtax_b (min/0=.), gen(unpaidtax)


*Arreas in service and other monthly bills
gen arrears_rec=dtserarr==1
recode dtserarr_b (min/0=.), gen(arrears)


*Other debts
gen dtother1_rec=dtoth1==1
recode dtoth1_b (min/0=.), gen(dtother1)

*Other debts
gen dtother2_rec=dtoth2==1
recode dtoth2_b (min/0=.), gen(dtother2)

* Retirement Funding

gen pension_rec=aspen==1
recode aspen_v (min/0=.), gen(pension)
gen temp1=.
replace temp1=250 if aspen_brac5==3   						//<500
replace temp1=500 if aspen_brac5==2  						//=500
replace temp1=2750 if aspen_brac5==1 & aspen_brac4==3 	 	//>500 & <5 000
replace temp1=5000 if aspen_brac4==2  						//=5 000
replace temp1=27500 if aspen_brac4==1 & aspen_brac1==3 		//>5 000 & < 50 000
replace temp1=50000 if aspen_brac1==2 						//=50 000
replace temp1=275000 if aspen_brac1==1 & aspen_brac2==3 	//>50 000 & < 500 000 
replace temp1=500000 if aspen_brac2==2 						//=500 000
replace temp1=750000 if aspen_brac2==1 & aspen_brac3==3 	//>500 000 & < 1 000 000 
replace temp1=1000000 if aspen_brac3==2 					//=1 000 000
replace temp1=3000000 if aspen_brac3==1 & aspen_brac6==3	//>1 000 000 & <5 000 000
replace temp1=5000000 if aspen_brac6==2  					//=5 000 000
replace temp1=10000000 if aspen_brac6==1 					//>5 000 000 

replace pension=temp1 if aspen == 1 & aspen_v <0  & pension==.
drop temp1

*Individual-level (one-shot) net worth
*positive net worth
recode assell_v (min/0=.), gen (ind_worth_pos)
gen temp=.
replace temp=2500 if assell_brac4==3						//<5 000
replace temp=5000 if assell_brac4==2						//=5 000
replace temp=7500 if assell_brac4==1 & assell_brac2==3		//>5 000 & < 10 000
replace temp=10000 if assell_brac2==2						//=10 000
replace temp=17500 if assell_brac2==1 & assell_brac1==3		//>10 000 & < 25 000
replace temp=25000 if assell_brac1==2						//=25 000
replace temp=37500 if assell_brac1==1 & assell_brac3==3		//>25 000 & <50 000
replace temp=50000 if assell_brac3==2						//=50 000
replace temp=75000 if assell_brac3==1 & assell_brac5==3		//>50 000 & < 100 000
replace temp=100000 if assell_brac5==2						//=100 000
replace temp=550000 if assell_brac5==1 & assell_brac6==3	//>100 000 & < 1 000 000
replace temp=1000000 if assell_brac6==2						//=1 000 000
replace temp=2000000 if assell_brac6==1						//>1 000 000

replace ind_worth_pos=temp if assell_v<0 & ind_worth_pos==.
drop temp

*negative net worth
recode dtsell_v (min/0=.), gen(ind_worth_neg)
gen temp=.
replace temp=2500 if dtsell_brac4==3						//<5 000
replace temp=5000 if dtsell_brac4==2						//=5 000
replace temp=7500 if dtsell_brac4==1 & assell_brac2==3		//>5 000 & < 10 000
replace temp=10000 if dtsell_brac2==2						//=10 000
replace temp=17500 if dtsell_brac2==1 & assell_brac1==3		//>10 000 & < 25 000
replace temp=25000 if dtsell_brac1==2						//=25 000
replace temp=37500 if dtsell_brac1==1 & assell_brac3==3		//>25 000 & <50 000
replace temp=50000 if dtsell_brac3==2						//=50 000
replace temp=75000 if dtsell_brac3==1 & assell_brac5==3		//>50 000 & < 100 000
replace temp=100000 if dtsell_brac5==2						//=100 000
replace temp=550000 if dtsell_brac5==1 & assell_brac6==3	//>100 000 & < 1 000 000
replace temp=1000000 if dtsell_brac6==2						//=1 000 000
replace temp=2000000 if dtsell_brac6==1						//>1 000 000

replace ind_worth_neg = temp if dtsell_v<0 & ind_worth_neg==. 
replace ind_worth_neg=-ind_worth_neg

gen ind_networth_i = ind_worth_pos if ind_worth_pos!=.
replace ind_networth_i = ind_worth_neg if ind_worth_neg !=. & ind_worth_pos ==.
replace ind_networth_i = . if ind_worth_pos!=. & ind_worth_neg!=.


foreach var of varlist houseval otherhouseval housedebt  otherhousedebt ///
cattle sheep goats pigs horses donkeys chickens posses{
replace `var'=. if hhresponse!=1
replace `var'_rec=. if hhresponse!=1
gen `var'_d=`var'!=.
replace `var'_d=. if hhresponse!=1
}

foreach var of varlist busass busdeb priveh scooter vehdebt ///
bank  stocks bankdebt micro masho studentloan otherstudentloan dtother1 dtother2 ///
creditcard store hirep famloan friendloan emploan unpaidtax pension bondowing_i posses_i arrears {
replace `var'=. if response!=1
replace `var'_rec=. if response!=1
gen `var'_d=`var'!=.
replace `var'_d=. if response!=1
}

save "$DataOUT\prepdata.dta", replace

* end of do file
*===================================================================================================================================
